package gov.va.mhv.portlet;

import com.liferay.faces.util.portal.WebKeys;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;

import java.util.ArrayList;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;


@ManagedBean(name = "webContentReader", eager = true)
@RequestScoped
/**
 * JSFWebContentReaderBean
 * @author rsilvestro
 *
 */
public class JSFWebContentReaderBean {
	private static Log logger = LogFactoryUtil.getLog(JSFWebContentReaderBean.class);

	/**
	 * This method displays web content created through the liferay web content portlet.
	 * @param id
	 * @return
	 */
	public String getWebContent(String id) {
		FacesContext context = FacesContext.getCurrentInstance();
		ThemeDisplay themeDisplay = (ThemeDisplay) context.getExternalContext().getRequestMap().get(WebKeys.THEME_DISPLAY);
		try {
			long groupId = themeDisplay.getScopeGroupId();
			Long articleId = new Long(id);
			JournalArticle article = JournalArticleLocalServiceUtil.getArticle(articleId);
			String languageKey = context.getExternalContext().getRequestLocale().toString();
			JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay(groupId, article.getArticleId(), article.getTemplateId(), languageKey, themeDisplay);
			return articleDisplay.getContent();
		} catch( Exception e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}
	
	/**
	 * Get all the articles currently in the database.  Useful to determine some valid ID's.
	 * @return
	 */
	public List<JournalArticleDisplay> getArticleList() {
		logger.debug("JSFWebContentReaderBean.getArticleList");
		List<JournalArticle> list = new ArrayList<JournalArticle>();
		List<JournalArticleDisplay> displayList = new ArrayList<JournalArticleDisplay>();
		try {
			list = JournalArticleLocalServiceUtil.getArticles();
			if( list != null && list.size() > 0 ) {
				FacesContext context = FacesContext.getCurrentInstance();
				ThemeDisplay themeDisplay = (ThemeDisplay) context.getExternalContext().getRequestMap().get(WebKeys.THEME_DISPLAY);
				String languageKey = context.getExternalContext().getRequestLocale().toString();
				long groupId = themeDisplay.getScopeGroupId();
				
				for( JournalArticle ja : list ) {
					JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay(groupId, ja.getArticleId(), ja.getTemplateId(), languageKey, themeDisplay);
					//articleDisplay.
					displayList.add(articleDisplay);
				}
			}
		} catch( Exception e) {
			e.printStackTrace();
		}
		return displayList;
	}

}


